----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------
-- Copyright (C)ViperGTS96, Confidential, All Rights Reserved.--------------
----------------------------------------------------------------------------
local sourceDir = g_currentModDirectory.."source/"
source(Utils.getFilename("fillType.lua", sourceDir));
source(Utils.getFilename("physics.lua", sourceDir));
source(Utils.getFilename("particles.lua", sourceDir));
source(Utils.getFilename("fieldSinkUpdater.lua", sourceDir));
source(Utils.getFilename("mudMask.lua", sourceDir));
source(Utils.getFilename("inactiveUpdater.lua", sourceDir));
source(Utils.getFilename("fillStation.lua", sourceDir));
source(Utils.getFilename("surfaceSounds.lua", sourceDir));

mudParticlesRegister = {};
mudParticlesRegister.modDirectory = g_currentModDirectory;

function mudParticlesRegister:loadMap(name)
    g_currentMission.mudSystemPS = {};
    g_currentMission.mudSystemPS.referencePS = {};
    local psFile = Utils.getFilename("particleSystems/mud.i3d", mudParticlesRegister.modDirectory);
    local psRoot = loadI3DFile(psFile, false, false, false);
    local psNode = I3DUtil.indexToObject(psRoot, "0");
    local ps = {};
    ParticleUtil.loadParticleSystemFromNode(psNode, ps, false, true, false);
    g_currentMission.mudSystemPS.referencePS = ps;
    link(getRootNode(), g_currentMission.mudSystemPS.referencePS.shape);
	setClipDistance(g_currentMission.mudSystemPS.referencePS.shape, 100);
	setMaxNumOfParticles(g_currentMission.mudSystemPS.referencePS.geometry, 3500);
    local shapeRoot = loadSharedI3DFile(mudParticlesRegister.modDirectory.."particleSystems/mudEmitShape.i3d", false, false);
    g_currentMission.mudSystemPS.referenceShape = getChildAt(shapeRoot, 0);
    link(getRootNode(), g_currentMission.mudSystemPS.referenceShape);
	setClipDistance(g_currentMission.mudSystemPS.referenceShape, 100);

	if g_currentMission.wheelDirt ~= nil then mudSystem:disableFieldPartciles(true); end;
end;

function mudParticlesRegister:deleteMap()
    if g_currentMission.mudSystemPS ~= nil then
        if g_currentMission.mudSystemPS.referencePS ~= nil then
            delete(g_currentMission.mudSystemPS.referencePS.shape);
        end;
        if g_currentMission.mudSystemPS.referenceShape ~= nil then
            delete(g_currentMission.mudSystemPS.referenceShape);
        end;
    end;
end;

function installSpec()
	if g_specializationManager:getSpecializationByName("mudSystem") == nil then
		if mudSystem == nil then 
			print("ERROR: unable to find 'Mud' source file 'particles.lua'");
		else 
			for typeName, typeDef in pairs(g_vehicleTypeManager.types) do
				if typeDef ~= nil and (typeName ~= "locomotive") then 
					local isWashable = false;	
					local isAnimated = false;
					local hasWheels = false;
					for name, spec in pairs(typeDef.specializationsByName) do 
						if name == "washable" then 
							isWashable = true;
						elseif name == "wheels" then 
							hasWheels = true;
						elseif name == "animatedVehicle" then 
							isAnimated = true;
						end;
					end;
					if isWashable and isAnimated and hasWheels then
						 if typeDef.specializationsByName["mudSystem"] == nil then
							table.insert(typeDef.specializations, mudSystem);
							table.insert(typeDef.specializationNames, "mudSystem");
							typeDef.specializationsByName["mudSystem"] = mudSystem;
						end;
					end;
				end;
			end;
		end;
	end;
end;

TypeManager.validateTypes = Utils.appendedFunction(TypeManager.validateTypes, installSpec);

addModEventListener(mudParticlesRegister);