----------------------------------------------------------------------------
-- @Author: ViperGTS96------------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------

RDCT_Prerequisites = {};
RDCT_Prerequisites.textColor = 1;
RDCT_Prerequisites.cycleBwd = false;
RDCT_Prerequisites.render = true;

function RDCT_Prerequisites:checkMods()
	local modsMissing = false;

	if g_currentMission.realDirtColor == nil or g_currentMission.realDirtFixEnabled == nil then
		addModEventListener(RDCT_Prerequisites); 
	end;

end;
FSBaseMission.onFinishedLoading = Utils.appendedFunction(FSBaseMission.onFinishedLoading, RDCT_Prerequisites.checkMods);

function RDCT_Prerequisites:draw()
	if RDCT_Prerequisites.render then
		local x = 0.5;
		local y = 0.15;
		local textSize = 0.035;
		textSize = textSize*g_gameSettings:getValue("uiScale");
		local oX = textSize * HUDTextDisplay.SHADOW_OFFSET_FACTOR;
		local baseString = "'Real Dirt Color Tracks' requires the mods: 'Real Dirt Color', and 'Real Dirt Fix'";
		local missingString = "'Real Dirt Color' is not installed, 'Real Dirt Fix' is not installed";
	
		if g_currentMission.realDirtColor ~= nil then
			missingString = "'Real Dirt Fix' is not installed";
		elseif g_currentMission.realDirtFixEnabled ~= nil then
			missingString = "'Real Dirt Color' is not installed";
		end;

		local sec = g_time/1000;
		if RDCT_Prerequisites.renderTimeInt == nil then RDCT_Prerequisites.renderTimeInt = sec; end;
		local delayTime = 30 - (sec - RDCT_Prerequisites.renderTimeInt);
		if delayTime < 0 then RDCT_Prerequisites.render = false; return; end;
		local timeString = "This message will be removed in "..tostring(math.floor(delayTime)).."sec";
	
		if RDCT_Prerequisites.textColor >= 1.0 then
			RDCT_Prerequisites.cycleBwd = true;
		elseif RDCT_Prerequisites.textColor <= 0.01 then
			RDCT_Prerequisites.cycleBwd = false;
		end;
		local dt = g_client.tickDuration or 33.3;
		if RDCT_Prerequisites.cycleBwd then
			RDCT_Prerequisites.textColor = RDCT_Prerequisites.textColor-(0.1*(dt/100));
		else
			RDCT_Prerequisites.textColor = RDCT_Prerequisites.textColor+(0.1*(dt/100));
		end;
		local red = math.max(RDCT_Prerequisites.textColor, 0.5);
		local alpha = math.max(RDCT_Prerequisites.textColor, 0);

		setTextBold(true);
		setTextAlignment(RenderText.ALIGN_CENTER);
		setTextColor(0,0,0,alpha);
		setTextAlignment(RenderText.ALIGN_CENTER);
		renderText(x+oX,y-oX,textSize,baseString);
		renderText(x+oX,(y-(textSize*1.5))-oX,textSize,missingString);
		renderText(x+oX,(y-(textSize*3))-oX,textSize/1.5,timeString);
		setTextColor(red,red/2,0,alpha);
		renderText(x,y,textSize,baseString);
		setTextColor(red,0,0,alpha);
		renderText(x,y-(textSize*1.5),textSize,missingString);
		renderText(x,y-(textSize*3),textSize/1.5,timeString);
		setTextBold(false);
	end;
end;
