﻿----------------------------------------------------------------------------
----Author: ViperGTS96------------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------

mudSystem_FillTypes = {}
mudSystem_FillTypes.dir = g_currentModDirectory;

function mudSystem_FillTypes:loadMap(savegame)

	if mudSystem_FillTypes.loaded == nil then
		----------------------------------------Create FillType------------------------------------------------------------
		local key = mudSystem_FillTypes.dir.."images/";
		local key2 = mudSystem_FillTypes.dir.."textures/";
		local baseDir = "";
		local fillPlaneColors = {0.05,0.05,0.05,0.9};
		local massPerLiter = 0.001;
		local showOnPriceTable = true;
		local pricePerLitre = 0.15;
		local maxSurfaceAngle = math.rad(50);
		local customEnv = nil;
		local unitShort = nil;
		local palletFilename = nil;
		local economicCurve = {};
		local diffuseMapFilename = key2.."dirtMS_diffuse.dds";
		local normalMapFilename = key2.."dirtMS_normal.dds";
		local specularMapFilename = key2.."dirtMS_specular.dds";
		local distanceFilename = key2.."dirtMS_diffuse_far.dds";
		local prioritizedEffectType = nil;
		local fillSmokeColor = nil;
		local fruitSmokeColor = nil;
		local achievementName = nil;
		local isBaseType = false;

		local dirtDesc = g_fillTypeManager:addFillType("dirt", g_i18n:getText("fillType_dirt"), showOnPriceTable, pricePerLitre, massPerLiter, maxSurfaceAngle, key.."hud_dirt.dds", baseDir, customEnv, fillPlaneColors, unitShort, palletFilename, economicCurve, diffuseMapFilename, normalMapFilename, specularMapFilename, distanceFilename, prioritizedEffectType, fillSmokeColor, fruitSmokeColor, achievementName, isBaseType);

		g_fillTypeManager:addFillTypeToCategory(dirtDesc.index, g_fillTypeManager.nameToCategoryIndex["BULK"]);
		g_fillTypeManager:addFillTypeToCategory(dirtDesc.index, g_fillTypeManager.nameToCategoryIndex["SHOVEL"]);

		showOnPriceTable = false;
		massPerLiter = 0.002;
		maxSurfaceAngle = math.rad(10);
		diffuseMapFilename = key2.."mudMS_diffuse.dds";
		normalMapFilename = key2.."mudMS_normal.dds";
		specularMapFilename = key2.."mudMS_specular.dds";
		distanceFilename = key2.."mudMS_diffuse_far.dds";

		local mudDesc = g_fillTypeManager:addFillType("mud", g_i18n:getText("fillType_mud"), showOnPriceTable, pricePerLitre, massPerLiter, maxSurfaceAngle, key.."hud_mud.dds", baseDir, customEnv, fillPlaneColors, unitShort, palletFilename, economicCurve, diffuseMapFilename, normalMapFilename, specularMapFilename, distanceFilename, prioritizedEffectType, fillSmokeColor, fruitSmokeColor, achievementName, isBaseType);
		
		g_fillTypeManager:addFillTypeToCategory(mudDesc.index, g_fillTypeManager.nameToCategoryIndex["BULK"]);
		g_fillTypeManager:addFillTypeToCategory(mudDesc.index, g_fillTypeManager.nameToCategoryIndex["SHOVEL"]);
		g_fillTypeManager:constructFillTypeTextureArrays();
		--------------------------------------Create DenistyMap------------------------------------------------------------
		maxSurfaceAngle = math.rad(42);
		local allowsSmoothing = true; --Can be flattened like chaff
		local fillToGroundScale = 3.0;
		local collisionScale = 1.0;
		local collisionBaseOffset = 0.05;
		local minCollisionOffset = 0.0;
		local maxCollisionOffset = 0.05;
		local dirtDensityMap = g_densityMapHeightManager:addDensityMapHeightType("dirt", maxSurfaceAngle, collisionScale, collisionBaseOffset, minCollisionOffset, maxCollisionOffset, fillToGroundScale, allowsSmoothing, isBaseType);
		maxSurfaceAngle = math.rad(10);
		allowsSmoothing = false;
		local mudDensityMap = g_densityMapHeightManager:addDensityMapHeightType("mud", maxSurfaceAngle, collisionScale, collisionBaseOffset, minCollisionOffset, maxCollisionOffset, fillToGroundScale, allowsSmoothing, isBaseType);

		g_fillTypeManager:constructDensityMapHeightTextureArrays(g_densityMapHeightManager.heightTypes);
		mudSystem_FillTypes.loaded = true;
	end;

	g_currentMission.hud.fillLevelsDisplay:refreshFillTypes(g_fillTypeManager);
	
    addConsoleCommand("removeAllDirt", g_i18n:getText("clearAllDirtCC"), "clearAllDirt", self);
	addConsoleCommand("removeAllMud", g_i18n:getText("clearAllMudCC"), "clearAllMud", self);
end;

function mudSystem_FillTypes:delete()
    removeConsoleCommand("removeAllDirt");
    removeConsoleCommand("removeAllMud");
end;

function mudSystem_FillTypes:clearAllDirt()
	local size = getTerrainSize(g_currentMission.terrainRootNode);
	DensityMapHeightUtil.removeFromGroundByArea(-size,-size,size,-size,-size,size, FillType.DIRT);
end;

function mudSystem_FillTypes:clearAllMud()
	local size = getTerrainSize(g_currentMission.terrainRootNode);
	DensityMapHeightUtil.removeFromGroundByArea(-size,-size,size,-size,-size,size, FillType.MUD);
end;

addModEventListener(mudSystem_FillTypes);