----------------------------------------------------------------------------
-- @Author: ViperGTS96------------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------
mudSystem_surfaceSounds = {};

function mudSystem_surfaceSounds:getCurrentSurfaceSound(superFunc, x, y, z, waterLevel, waterY)
	local mask = CollisionFlag.STATIC_WORLD + CollisionFlag.PLAYER + CollisionFlag.ANIMAL + CollisionFlag.TERRAIN;
	self.belowPlayerObject = nil;

	raycastClosest(x, y + 0.5, z, 0, -1, 0, "groundRaycastCallback", 10, self, mask);

	local hitTerrain = self.belowPlayerObject == g_currentMission.terrainRootNode;
	local deltaWater = y - waterY;
	local isInWater = deltaWater < 0;
	local shallowWater = isInWater and deltaWater >= -0.6;
	local mediumWater = isInWater and waterLevel < deltaWater and not shallowWater;

	if hitTerrain then
		local snowHeight = g_currentMission.snowSystem:getSnowHeightAtArea(x, z, x + 0.1, z + 0.1, x + 0.1, z);

		if snowHeight > 0 then
			return self.soundInformation.surfaceNameToSound.snow, shallowWater;
		else
		-------------------------
			local y1 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x,y,z);
			local y2 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x+.01,y,z+0.1);
			local foundFillType = DensityMapHeightUtil.getFillTypeAtLine(x,y1,z, x+0.1,y2,z+0.1, 1.0);
			if foundFillType == FillType.MUD then
				return self.soundInformation.surfaceIdToSound[8], shallowWater;
			end;
		-------------------------
			local isOnField, _ = FSDensityMapUtil.getFieldDataAtWorldPosition(x, y, z);

			if isOnField then
				return self.soundInformation.surfaceNameToSound.field, shallowWater;
			elseif mediumWater then
				return self.soundInformation.surfaceNameToSound.mediumWater, shallowWater;
			elseif shallowWater then
				return self.soundInformation.surfaceNameToSound.shallowWater, shallowWater;
			end;
		end;

		local _, _, _, _, materialId = getTerrainAttributesAtWorldPos(g_currentMission.terrainRootNode, x, y, z, true, true, true, true, false);

		return self.soundInformation.surfaceIdToSound[materialId], shallowWater;
	else
		return self.soundInformation.surfaceNameToSound.asphalt, shallowWater;
	end;
end;

PlayerModel.getCurrentSurfaceSound = Utils.overwrittenFunction(PlayerModel.getCurrentSurfaceSound, mudSystem_surfaceSounds.getCurrentSurfaceSound);