----------------------------------------------------------------------------
-- @Author: ViperGTS96------------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------

realDirtColorTracks = {};
realDirtColorTracks.modDirectory  = g_currentModDirectory;
local modDesc = loadXMLFile("modDesc", realDirtColorTracks.modDirectory .. "modDesc.xml");
realDirtColorTracks.version = getXMLString(modDesc, "modDesc.version");
realDirtColorTracks.title = getXMLString(modDesc, "modDesc.title.en");
realDirtColorTracks.author = getXMLString(modDesc, "modDesc.author");
realDirtColorTracks.rainbowTracks = false;
realDirtColorTracks.revertSpeed = 2;
realDirtColorTracks.coloredSpeed = 5;

function realDirtColorTracks.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Washable, specializations)
		and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function realDirtColorTracks.registerFunctions(vehicleType)
	SpecializationUtil.registerFunction(vehicleType, "loadRealDirtColorTracks", realDirtColorTracks.loadRealDirtColorTracks);
	SpecializationUtil.registerFunction(vehicleType, "saveRealDirtColorTracks", realDirtColorTracks.saveRealDirtColorTracks);
	SpecializationUtil.registerFunction(vehicleType, "getTireEffectColors", realDirtColorTracks.getTireEffectColors);
	SpecializationUtil.registerFunction(vehicleType, "updateTireEffectColors", realDirtColorTracks.updateTireEffectColors);
end;

function realDirtColorTracks:getTireEffectColors(wheel, r,g,b,a)
	if self.spec_realDirtColor ~= nil then
		local specRDC = self.spec_realDirtColor;
		if wheel.rDC ~= nil or specRDC.useSimpleMode then
			local defaultColor = false;
			local rR, gG, bB = r,g,b;
			if wheel.rDC ~= nil and wheel.tireTrackColor ~= nil then
				rR, gG, bB = wheel.tireTrackColor.r, wheel.tireTrackColor.g, wheel.tireTrackColor.b;
				defaultColor = wheel.tireTrackColorDefault;
			elseif specRDC.tireTrackColor ~= nil then
				rR, gG, bB = specRDC.tireTrackColor.r, specRDC.tireTrackColor.g, specRDC.tireTrackColor.b;
				defaultColor = specRDC.tireTrackColorDefault;
			end;
			if not defaultColor then
				r, g, b = rR, gG, bB;
				wheel.lastColor[1] = r ;
				wheel.lastColor[2] = g;
				wheel.lastColor[3] = b;
			end;
		end;
	end;
	return r,g,b,a;
end;

function realDirtColorTracks:updateTireEffectColors(wheel, dirtColor, variableSpeed, dt)
	if self.spec_realDirtColor ~= nil then
		local speedFactor = math.max(1,self:getLastSpeed()/10);
		if wheel == nil then
			local spec = self.spec_realDirtColor;
			if spec.useSimpleMode and self.spec_wheels ~= nil then
				local isOnField = spec.isOnFillTypeRDC ~= nil and spec.isOnFillTypeRDC;
				local 	hasEffects = false;
				for _,wheelSimple in pairs(self.spec_wheels.wheels) do
					if wheelSimple.hasTireTracks or wheelSimple.hasParticles then
						hasEffects = true;
						--if spec.currentDirtColor == 0.1 then break; end;
						if wheelSimple.hasSnowContact == nil and wheelSimple.densityType == nil then break; end;
						if wheelSimple.hasSnowContact or wheelSimple.densityType ~= 0 then isOnField = true; end;
						if isOnField then break; end;
					end;
				end;
				if hasEffects then
					if spec.currentDirtColor == 0.1 or not isOnField then
						local surfaceColor = {};
						if isOnField then
							local xSurface, ySurface, zSurface = getWorldTranslation(self.components[1].node);
							ySurface = Utils.getNoNil(getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, xSurface, ySurface, zSurface),ySurface);
							local densityBits = getDensityAtWorldPos(g_currentMission.terrainDetailId, xSurface, ySurface, zSurface);
							if densityBits ~= nil then
								local _ = nil;
								surfaceColor.r,surfaceColor.g,surfaceColor.b, _ = g_currentMission.fieldGroundSystem:getFieldGroundTyreTrackColor(densityBits);
							else
								surfaceColor.r,surfaceColor.g,surfaceColor.b = realDirtColorTracks.defTrackColor.r, realDirtColorTracks.defTrackColor.g, realDirtColorTracks.defTrackColor.b;
							end;
						else
							surfaceColor.r,surfaceColor.g,surfaceColor.b = realDirtColorTracks.dryDirtColor.r, realDirtColorTracks.dryDirtColor.g, realDirtColorTracks.dryDirtColor.b;
						end;
						if self:thresholdCompareColor(spec.tireTrackColor, surfaceColor, 0.0001) then
							spec.tireTrackColor.r, spec.tireTrackColor.g, spec.tireTrackColor.b = surfaceColor.r,surfaceColor.g,surfaceColor.b;
							spec.tireTrackColorDefault = true;
						else
							spec.tireTrackColorDefault = false;
							if spec.tireTrackColorDelay > 0 then
								spec.tireTrackColorDelay = spec.tireTrackColorDelay*-1;
							end;
							if spec.tireTrackColorDelay < 0 then
								local decAmt = 1-(dt/1000);
								spec.tireTrackColorDelay = math.min(spec.tireTrackColorDelay + (decAmt*speedFactor),0);
							elseif spec.tireTrackColorDelay == 0 then
								spec.tireTrackColor.r, spec.tireTrackColor.g, spec.tireTrackColor.b = self:colorChangeLerp(spec.tireTrackColor, surfaceColor, realDirtColorTracks.revertSpeed*speedFactor);
							end;
						end;
					else
						if spec.tireTrackColorDefault then
							spec.tireTrackColor.r, spec.tireTrackColor.g, spec.tireTrackColor.b = dirtColor.r, dirtColor.g, dirtColor.b;
						else
							spec.tireTrackColor.r, spec.tireTrackColor.g, spec.tireTrackColor.b = self:colorChangeLerp(spec.tireTrackColor, dirtColor, realDirtColorTracks.coloredSpeed*speedFactor);--spec.targetRDColor
						end;
						spec.tireTrackColorDelay = 75;
						spec.tireTrackColorDefault = false;
					end;
				end;
			end;
		else
			-----------------------------------Wheels-----------------------------------------------------------------------------------------------------------------------
			if wheel.hasTireTracks or wheel.hasParticles then
				local isOnField = false;
				--if wheel.currentDirtColor ~= 0.1 then
				if wheel.hasSnowContact ~= nil and wheel.densityType ~= nil then
					if wheel.isOnFillTypeRDC ~= nil and wheel.isOnFillTypeRDC then isOnField = true; end;
					if wheel.hasSnowContact or wheel.densityType ~= 0 then isOnField = true; end;
				end;
				--end;
				if wheel.currentDirtColor == 0.1 or not isOnField then
					local surfaceColor = {}
					if isOnField then
						if wheel.densityBits ~= nil then
							local _ = nil;
							surfaceColor.r,surfaceColor.g,surfaceColor.b, _ = g_currentMission.fieldGroundSystem:getFieldGroundTyreTrackColor(wheel.densityBits);
						else
							surfaceColor.r,surfaceColor.g,surfaceColor.b = realDirtColorTracks.defTrackColor.r, realDirtColorTracks.defTrackColor.g, realDirtColorTracks.defTrackColor.b;
						end;
					else
						surfaceColor.r,surfaceColor.g,surfaceColor.b = realDirtColorTracks.dryDirtColor.r, realDirtColorTracks.dryDirtColor.g, realDirtColorTracks.dryDirtColor.b;
					end;
					if self:thresholdCompareColor(wheel.tireTrackColor, surfaceColor, 0.0001) then
						wheel.tireTrackColor.r, wheel.tireTrackColor.g, wheel.tireTrackColor.b = surfaceColor.r,surfaceColor.g,surfaceColor.b;
						wheel.tireTrackColorDefault = true;
					else
						wheel.tireTrackColorDefault = false;
						if wheel.tireTrackColorDelay > 0 then
							wheel.tireTrackColorDelay = wheel.tireTrackColorDelay*-1;
						end;
						if wheel.tireTrackColorDelay < 0 then
							local decAmt = 1-(dt/1000);
							wheel.tireTrackColorDelay = math.min(wheel.tireTrackColorDelay + (decAmt*speedFactor),0);
						elseif wheel.tireTrackColorDelay == 0 then
							wheel.tireTrackColor.r, wheel.tireTrackColor.g, wheel.tireTrackColor.b = self:colorChangeLerp(wheel.tireTrackColor, surfaceColor, realDirtColorTracks.revertSpeed*speedFactor);
						end;
					end;
				else
					wheel.tireTrackColor.r, wheel.tireTrackColor.g, wheel.tireTrackColor.b = self:colorChangeLerp(wheel.tireTrackColor, dirtColor, realDirtColorTracks.coloredSpeed*speedFactor);--wheel.targetRDColor
					wheel.tireTrackColorDefault = false;
					wheel.tireTrackColorDelay = 125;
				end;
				--if wheel.lastColor ~= nil and not wheel.tireTrackColorDefault then -- Sets Driving PS Color
					--wheel.lastColor = {wheel.tireTrackColor.r, wheel.tireTrackColor.g, wheel.tireTrackColor.b, wheel.lastColor[4]};
				--end;
				--g_currentMission:addExtraPrintText(wheel.tireTrackColor.r.." : "..wheel.tireTrackColor.g.." : "..wheel.tireTrackColor.b);
			end;
		end;
	end;
end;

function realDirtColorTracks:addTrackPoint(superFunc, id, x, y, z, ux, uy, uz, r, g, b, a, uw, dtheta)
	a = 1; r=math.random(1,10)*0.1; g=math.random(1,10)*0.1; b=math.random(1,10)*0.1;
	addTrackPoint(self.systemId, id, x, y, z, ux, uy, uz, r, g, b, a, uw, dtheta);
end;

function realDirtColorTracks:enableRainbow()
	TireTrackSystem.addTrackPoint = Utils.overwrittenFunction(TireTrackSystem.addTrackPoint, realDirtColorTracks.addTrackPoint);
end;

function realDirtColorTracks:loadRDCData()
	if g_currentMission.realDirtColor ~= nil then
		realDirtColorTracks.colors = g_currentMission.realDirtColor.colors;
		realDirtColorTracks.speeds = g_currentMission.realDirtColor.speeds;
		
		local xmLfileName = getUserProfileAppPath().."modSettings/realDirtColorTracks.xml";

		if not fileExists(xmLfileName) then
			copyFile(realDirtColorTracks.modDirectory.."templates/settingsTemplate.xml", xmLfileName, false);
		end;
		local settingsFile = loadXMLFile("realDirtColorTracks_XML", xmLfileName, "realDirtColorTracksSettings");
		if settingsFile ~= nil then
			realDirtColorTracks.coloredSpeed = Utils.getNoNil(getXMLFloat(settingsFile, "settings.colorSettings.coloringSpeed#value"), realDirtColorTracks.coloredSpeed);
			realDirtColorTracks.revertSpeed = Utils.getNoNil(getXMLFloat(settingsFile, "settings.colorSettings.revertSpeed#value"), realDirtColorTracks.revertSpeed);
			realDirtColorTracks.rainbowTracks = Utils.getNoNil(getXMLBool(settingsFile, "settings.justForFun.rainbowTracks#value"), realDirtColorTracks.rainbowTracks);
			delete(settingsFile);
		else
			Logging.warning(realDirtColorTracks.title..": Cannot find settings, default values will be used..");
		end;
		
		if realDirtColorTracks.rainbowTracks then realDirtColorTracks:enableRainbow(); end;

		realDirtColorTracks.coloredSpeed = MathUtil.clamp(realDirtColorTracks.coloredSpeed, 0.2, 20);
		realDirtColorTracks.coloredSpeed = realDirtColorTracks.speeds.wheels*realDirtColorTracks.coloredSpeed;
		realDirtColorTracks.revertSpeed = MathUtil.clamp(realDirtColorTracks.revertSpeed, 0.1, 10);
		realDirtColorTracks.revertSpeed = realDirtColorTracks.speeds.wheels*realDirtColorTracks.revertSpeed;
		local color = g_currentMission.fieldGroundSystem.fieldGroundTypeTyreTrackColor[FieldGroundType.PLOWED];
		realDirtColorTracks.defTrackColor = {r=color[1],g=color[2],b=color[3]};
		realDirtColorTracks.dryDirtColor = realDirtColorTracks.colors.dryDirt;
	else
		Logging.error(realDirtColorTracks.title.." : cannot find data from 'Real Dirt Color' mod. Please install 'Real Dirt Color' mod & 'Real Dirt Fix' mod.");
	end;
end;
FSBaseMission.onFinishedLoading = Utils.appendedFunction(FSBaseMission.onFinishedLoading, realDirtColorTracks.loadRDCData);

function realDirtColorTracks:loadRealDirtColorTracks(savegame)
	if self.spec_realDirtColor ~= nil then
		local spec = self.spec_realDirtColor;
		if spec.useSimpleMode then
			spec.tireTrackColor = {};
			spec.tireTrackColor.r, spec.tireTrackColor.g, spec.tireTrackColor.b = spec.targetRDColor.r, spec.targetRDColor.g, spec.targetRDColor.b;
			spec.tireTrackColorDefault = true;
			spec.tireTrackColorDelay = 0;
		else
			if self.spec_wheels ~= nil and self.spec_wheels.wheels ~= nil and #self.spec_wheels.wheels ~= 0 then
				for i, wheel in pairs(self.spec_wheels.wheels) do
					if wheel.rDC ~= nil and wheel.rDC then
						wheel.tireTrackColor = {};
						wheel.tireTrackColor.r, wheel.tireTrackColor.g, wheel.tireTrackColor.b = wheel.targetRDColor.r, wheel.targetRDColor.g, wheel.targetRDColor.b;
						wheel.tireTrackColorDefault = true;
						wheel.tireTrackColorDelay = 0;
					end;
				end;
			end;
		end;

		if savegame ~= nil then
			if spec.useSimpleMode then
				spec.tireTrackColor.r = Utils.getNoNil(getXMLFloat(savegame.xmlFile.handle, savegame.key .. string.format(".realDirtColorTracks.simpleMode#r")), spec.tireTrackColor.r);
				spec.tireTrackColor.g = Utils.getNoNil(getXMLFloat(savegame.xmlFile.handle, savegame.key .. string.format(".realDirtColorTracks.simpleMode#g")), spec.tireTrackColor.g);
				spec.tireTrackColor.b = Utils.getNoNil(getXMLFloat(savegame.xmlFile.handle, savegame.key .. string.format(".realDirtColorTracks.simpleMode#b")), spec.tireTrackColor.b);
				spec.tireTrackColorDefault = Utils.getNoNil(getXMLBool(savegame.xmlFile.handle, savegame.key .. string.format(".realDirtColorTracks.simpleMode#colorIsDefault")), spec.tireTrackColorDefault);
			elseif self.spec_wheels ~= nil and self.spec_wheels.wheels ~= nil and #self.spec_wheels.wheels ~= 0 then
				for i, wheel in pairs(self.spec_wheels.wheels) do
					if wheel.rDC ~= nil and wheel.rDC then
						wheel.tireTrackColor.r = Utils.getNoNil(getXMLFloat(savegame.xmlFile.handle, savegame.key .. string.format(".realDirtColorTracks.wheel"..i.."#r")), wheel.tireTrackColor.r);
						wheel.tireTrackColor.g = Utils.getNoNil(getXMLFloat(savegame.xmlFile.handle, savegame.key .. string.format(".realDirtColorTracks.wheel"..i.."#g")), wheel.tireTrackColor.g);
						wheel.tireTrackColor.b = Utils.getNoNil(getXMLFloat(savegame.xmlFile.handle, savegame.key .. string.format(".realDirtColorTracks.wheel"..i.."#b")), wheel.tireTrackColor.b);
						wheel.tireTrackColorDefault = Utils.getNoNil(getXMLBool(savegame.xmlFile.handle, savegame.key .. string.format(".realDirtColorTracks.wheel"..i.."#colorIsDefault")), wheel.tireTrackColorDefault);
					end;
				end;
			end;
		end;
	end;
end;

function realDirtColorTracks:saveRealDirtColorTracks(xmlFile, key)
	if self.spec_realDirtColor ~= nil then
		local spec = self.spec_realDirtColor;
		if spec.useSimpleMode then
			setXMLFloat(xmlFile.handle, key.."Tracks.simpleMode#r", spec.tireTrackColor.r);
			setXMLFloat(xmlFile.handle, key.."Tracks.simpleMode#g", spec.tireTrackColor.g);
			setXMLFloat(xmlFile.handle, key.."Tracks.simpleMode#b", spec.tireTrackColor.b);
			setXMLBool(xmlFile.handle, key.."Tracks.simpleMode#colorIsDefault", spec.tireTrackColorDefault);
		elseif self.spec_wheels ~= nil and self.spec_wheels.wheels ~= nil and #self.spec_wheels.wheels ~= 0 then
			for i, wheel in pairs(self.spec_wheels.wheels) do
				if wheel.rDC ~= nil and wheel.rDC then
					setXMLFloat(xmlFile.handle, key.."Tracks.wheel"..i.."#r", wheel.tireTrackColor.r);
					setXMLFloat(xmlFile.handle, key.."Tracks.wheel"..i.."#g", wheel.tireTrackColor.g);
					setXMLFloat(xmlFile.handle, key.."Tracks.wheel"..i.."#b", wheel.tireTrackColor.b);
					setXMLBool(xmlFile.handle, key.."Tracks.wheel"..i.."#colorIsDefault", wheel.tireTrackColorDefault);
				end;
			end;
		end;
	end;
end;