----------------------------------------------------------------------------
-- @Author: ViperGTS96-----------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------

RealDirtFix = {};
RealDirtFix.modDirectory  = g_currentModDirectory;
local modDescFile = loadXMLFile("modDesc", RealDirtFix.modDirectory .. "modDesc.xml");
RealDirtFix.title = getXMLString(modDescFile, "modDesc.title.en");
RealDirtFix.author = getXMLString(modDescFile, "modDesc.author");
RealDirtFix.version = getXMLString(modDescFile, "modDesc.version");
delete(modDescFile);

function RealDirtFix:updateDirtAmount(superFunc, nodeData, dt, allowsWashingByRain, rainScale, timeSinceLastRain, temperature)
	local spec = self.spec_washable;
	local change = 0;

	if not g_currentMission.realDirtFixEnabled then
		if allowsWashingByRain and rainScale > 0.1 and timeSinceLastRain < 30 and temperature > 0 and nodeData.dirtAmount > 0.5 then
			change = -(dt / spec.washDuration);
		end;
	end;

	local dirtMultiplier = spec.lastDirtMultiplier;

	if dirtMultiplier ~= 0 then
		change = dt * spec.dirtDuration * dirtMultiplier;
	end;

	return change;
end;

function RealDirtFix:updateWheelDirtAmount(superFunc, nodeData, dt, allowsWashingByRain, rainScale, timeSinceLastRain, temperature)
	local dirtAmount = self:updateDirtAmount(nodeData, dt, allowsWashingByRain, rainScale, timeSinceLastRain, temperature);
	local allowManipulation = true;

	if nodeData.wheel ~= nil and nodeData.wheel.contact == Wheels.WHEEL_NO_CONTACT then
		allowManipulation = false;
	end;

	if allowManipulation then
		local spec = self.spec_wheels;
		local isOnField = nodeData.wheel.hasSnowContact;

		if nodeData.wheel ~= nil and nodeData.wheel.densityType ~= 0 then
			if g_currentMission.realDirtFixEnabled or (nodeData.wheel.densityType ~= spec.tireTrackGroundGrassValue and nodeData.wheel.densityType ~= spec.tireTrackGroundGrassCutValue) then
				isOnField = true;
			end;
		end;

		local lastSpeed = self.lastSpeed * 3600;

		if isOnField then
			dirtAmount = dirtAmount * nodeData.fieldDirtMultiplier;
		elseif not g_currentMission.realDirtFixEnabled then
			if nodeData.minDirtPercentage < nodeData.dirtAmount then
				local speedFactor = lastSpeed / 20
				dirtAmount = dirtAmount * nodeData.streetDirtMultiplier * speedFactor
			end;
		end;

		local globalValue = self.spec_washable.washableNodes[1].dirtAmount;
		local minDirtOffset = nodeData.maxDirtOffset * (math.pow(1 - globalValue, 2) * 0.75 + 0.25);
		local maxDirtOffset = nodeData.maxDirtOffset * (math.pow(1 - globalValue, 2) * 0.95 + 0.05);

		if minDirtOffset < globalValue - nodeData.dirtAmount then
			if dirtAmount < 0 then
				dirtAmount = 0;
			end;
		elseif globalValue - nodeData.dirtAmount < -maxDirtOffset and dirtAmount > 0 then
			dirtAmount = 0;
		end;

		local factor = nodeData.wheel.hasSnowContact and 1 or -0.25;
		local speedFactor = math.min(lastSpeed / 5, 2);
		local lastSnowScale = nodeData.wheel.snowScale;
		nodeData.wheel.snowScale = math.min(math.max(lastSnowScale + factor * dt * nodeData.dirtColorChangeSpeed * speedFactor, 0), 1);

		if nodeData.wheel.snowScale ~= lastSnowScale then
			local defaultColor, snowColor = g_currentMission.environment:getDirtColors();
			local r, g, b = MathUtil.lerp3(defaultColor[1], defaultColor[2], defaultColor[3], snowColor[1], snowColor[2], snowColor[3], nodeData.wheel.snowScale);
			self:setNodeDirtColor(nodeData, r, g, b);
		end;
	end;

	return dirtAmount;
end;

function RealDirtFix:getTireTrackColor(superFunc, wheel, wx, wy, wz, groundWetness)
    local r, g, b, a, t = superFunc(self,wheel, wx, wy, wz, groundWetness);
	if wheel.contact == Wheels.WHEEL_GROUND_CONTACT then
		local isOnField = wheel.densityType ~= 0;
		local dirtAmount = 1
		if isOnField then
			local spec = self.spec_wheels;
			r, g, b, a = spec.fieldGroundSystem:getFieldGroundTyreTrackColor(wheel.densityBits);
			t = 1;
			if not g_currentMission.realDirtFixEnabled then
				if wheel.densityType == spec.tireTrackGroundGrassValue then
					dirtAmount = 0.7;
				elseif wheel.densityType == spec.tireTrackGroundGrassCutValue then
					dirtAmount = 0.6;
				end;
			end;
		else
			r, g, b, a, t = getTerrainAttributesAtWorldPos(g_currentMission.terrainRootNode, wx, wy, wz, true, true, true, true, false);
			if not g_currentMission.realDirtFixEnabled then
				dirtAmount = 0.5
			end;
		end;
		if not g_currentMission.realDirtFixEnabled then
			wheel.dirtAmount = dirtAmount;
		end;
		wheel.lastColor[1] = r ;
		wheel.lastColor[2] = g;
		wheel.lastColor[3] = b;
		wheel.lastColor[4] = a;
		wheel.lastTerrainAttribute = t;
		if self.getTireEffectColors ~= nil then
			r,g,b,a = self:getTireEffectColors(wheel,r,g,b,a);
		end;
	elseif wheel.contact == Wheels.WHEEL_OBJ_CONTACT and wheel.lastContactObjectAllowsTireTracks and wheel.dirtAmount > 0 then
		local maxTrackLength = 30 * (1 + groundWetness);
		local speedFactor = math.min(self:getLastSpeed(), 20) / 20;
		maxTrackLength = maxTrackLength * (2 - speedFactor);
		if not g_currentMission.realDirtFixEnabled then
			wheel.dirtAmount = math.max(wheel.dirtAmount - self.lastMovedDistance / maxTrackLength, 0)
		end;
		b = wheel.lastColor[3];
		g = wheel.lastColor[2];
		r = wheel.lastColor[1];
		a = 0;
		if self.getTireEffectColors ~= nil then
			r,g,b,a = self:getTireEffectColors(wheel,r,g,b,a);
		end;
	end;

	return r, g, b, a, t;
end;

function RealDirtFix:loadMap(savegame)
	local useDefaultDirtLimiting = false;
	local settingsFilePath = getUserProfileAppPath().."modSettings/realDirtFix.xml";
	local activateText = "activated";
	if fileExists(settingsFilePath) then
		local settingsFile = loadXMLFile("realDirtFix_XML", settingsFilePath, "realDirtFixSettings");
		useDefaultDirtLimiting = Utils.getNoNil(getXMLBool(settingsFile, "settings.modTrackColorOnly#value"), useDefaultDirtLimiting);
		delete(settingsFile);
	else
		copyFile(RealDirtFix.modDirectory.."templates/settingsTemplate.xml", settingsFilePath, false);
	end;

	g_currentMission.realDirtFixEnabled = not useDefaultDirtLimiting;

	if not g_currentMission.realDirtFixEnabled then
		activateText = "activated only as support for 'R.D.C. Tracks'";
	end;

	print(RealDirtFix.title.." : v"..RealDirtFix.version.." by "..RealDirtFix.author.." "..activateText);
end;

Washable.updateDirtAmount = Utils.overwrittenFunction(Washable.updateDirtAmount, RealDirtFix.updateDirtAmount);
Wheels.updateWheelDirtAmount = Utils.overwrittenFunction(Wheels.updateWheelDirtAmount, RealDirtFix.updateWheelDirtAmount);
Wheels.getTireTrackColor = Utils.overwrittenFunction(Wheels.getTireTrackColor, RealDirtFix.getTireTrackColor);
addModEventListener(RealDirtFix);